/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.lux;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.EnemyCreatureEntity;
import entities.creatures.enemies.LuxEntity;
import entities.missiles.BoomerangMissileEntity;
import java.util.ArrayList;
import java.util.Random;
import util.Config;
import util.ResourceManager;

public final class LuxAbilityWEntity
extends BoomerangMissileEntity {
    private long lastFrameChange;
    private Random random;
    private ArrayList<CreatureEntity> entities = new ArrayList();

    public LuxAbilityWEntity(LuxEntity parent, GameState game, int x, int y) {
        super(parent, game, "missiles/lux/abilityW", x, y);
        this.random = new Random();
        this.removeWhenOutOfArea = false;
        this.moveSpeed = Config.get(Config.luxAbilityWProjectileSpeed);
        this.phase1Time = Config.get(Config.luxAbilityWPhase1Time);
        this.dy = this.random.nextDouble() * this.moveSpeed;
        this.dx = this.moveSpeed - this.dy;
        if (this.random.nextBoolean()) {
            this.dx = -this.dx;
        }
        if (this.random.nextBoolean()) {
            this.dy = -this.dy;
        }
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        this.lastFrameChange += delta;
        if (this.lastFrameChange > 10L) {
            this.lastFrameChange = 0L;
            this.sprite.rotate(13.0f);
        }
    }

    @Override
    public void phase1IsOver() {
        super.phase1IsOver();
        this.entities.clear();
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof EnemyCreatureEntity && !this.entities.contains(other)) {
            this.entities.add((CreatureEntity)other);
            ((CreatureEntity)other).shield(Config.get(Config.luxAbilityWShieldAmount), Config.get(Config.luxAbilityWShieldTime));
            ((CreatureEntity)other).addEffect("shieldLux", this.game.getTime() + (long)Config.get(Config.luxAbilityWShieldTime));
        }
        if (!this.phase1 && other == this.parent) {
            ResourceManager.get().stopSound("lux_abilityW");
            ResourceManager.get().stopSound("lux_abilityW2");
            ResourceManager.get().playSound("lux_abilityW_hit");
            this.game.removeEntity(this);
        }
    }
}

